// CLS_PageSettingMutiSreen.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_PageSettingMutiSreen.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "CLS_DlgScreenParam.h"
// CLS_PageSettingMutiSreen dialog

IMPLEMENT_DYNAMIC(CLS_PageSettingMutiSreen, CDialog)

CLS_PageSettingMutiSreen::CLS_PageSettingMutiSreen(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_PageSettingMutiSreen::IDD, pParent)
{
	m_iChannelNum = 0;
	memset(&m_strctCreateVVOInfo, 0, sizeof(CreateVVOInfo)*DEC_MAX_SPLIT_CHANNEL_NUM);
	for (int i=0; i<DEC_MAX_SPLIT_CHANNEL_NUM; i++)//õƴѾʹõͨ.
	{
		m_strctCreateVVOInfo[i].iBufSize = sizeof(CreateVVOInfo);
		memset(&m_strctCreateVVOInfo[i].iInputChannel,FILL_CHANNEL_INVALIDATE_DATA,sizeof(m_strctCreateVVOInfo[i].iInputChannel));
	}

	m_iConMode = 0;
}

CLS_PageSettingMutiSreen::~CLS_PageSettingMutiSreen()
{
}

void CLS_PageSettingMutiSreen::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_MODE, m_cmbConMode);
	DDX_Control(pDX, IDC_COMBO_NO, m_cmbScreenNo);
	DDX_Control(pDX, IDC_COMBO_CHN1, m_cboSplitScreen[0][0]);
	DDX_Control(pDX, IDC_COMBO_CHN2, m_cboSplitScreen[0][1]);
	DDX_Control(pDX, IDC_COMBO_CHN3, m_cboSplitScreen[0][2]);
	DDX_Control(pDX, IDC_COMBO_CHN4, m_cboSplitScreen[0][3]);
	DDX_Control(pDX, IDC_COMBO_CHN5, m_cboSplitScreen[0][4]);
	DDX_Control(pDX, IDC_COMBO_CHN6, m_cboSplitScreen[1][0]);
	DDX_Control(pDX, IDC_COMBO_CHN7, m_cboSplitScreen[1][1]);
	DDX_Control(pDX, IDC_COMBO_CHN8, m_cboSplitScreen[1][2]);
	DDX_Control(pDX, IDC_COMBO_CHN9, m_cboSplitScreen[1][3]);
	DDX_Control(pDX, IDC_COMBO_CHN10, m_cboSplitScreen[1][4]);
	DDX_Control(pDX, IDC_COMBO_CHN11, m_cboSplitScreen[2][0]);
	DDX_Control(pDX, IDC_COMBO_CHN12, m_cboSplitScreen[2][1]);
	DDX_Control(pDX, IDC_COMBO_CHN13, m_cboSplitScreen[2][2]);
	DDX_Control(pDX, IDC_COMBO_CHN14, m_cboSplitScreen[2][3]);
	DDX_Control(pDX, IDC_COMBO_CHN15, m_cboSplitScreen[2][4]);
	DDX_Control(pDX, IDC_COMBO_CHN16, m_cboSplitScreen[3][0]);
	DDX_Control(pDX, IDC_COMBO_CHN17, m_cboSplitScreen[3][1]);
	DDX_Control(pDX, IDC_COMBO_CHN18, m_cboSplitScreen[3][2]);
	DDX_Control(pDX, IDC_COMBO_CHN19, m_cboSplitScreen[3][3]);
	DDX_Control(pDX, IDC_COMBO_CHN20, m_cboSplitScreen[3][4]);
	DDX_Control(pDX, IDC_COMBO_CHN21, m_cboSplitScreen[4][0]);
	DDX_Control(pDX, IDC_COMBO_CHN22, m_cboSplitScreen[4][1]);
	DDX_Control(pDX, IDC_COMBO_CHN23, m_cboSplitScreen[4][2]);
	DDX_Control(pDX, IDC_COMBO_CHN24, m_cboSplitScreen[4][3]);
	DDX_Control(pDX, IDC_COMBO_CHN25, m_cboSplitScreen[4][4]);
	DDX_Control(pDX, IDC_BUTTON_1, m_stcSplitScreen[0][0]);
	DDX_Control(pDX, IDC_BUTTON_2, m_stcSplitScreen[0][1]);
	DDX_Control(pDX, IDC_BUTTON_3, m_stcSplitScreen[0][2]);
	DDX_Control(pDX, IDC_BUTTON_4, m_stcSplitScreen[0][3]);
	DDX_Control(pDX, IDC_BUTTON_5, m_stcSplitScreen[0][4]);
	DDX_Control(pDX, IDC_BUTTON_6, m_stcSplitScreen[1][0]);
	DDX_Control(pDX, IDC_BUTTON_7, m_stcSplitScreen[1][1]);
	DDX_Control(pDX, IDC_BUTTON_8, m_stcSplitScreen[1][2]);
	DDX_Control(pDX, IDC_BUTTON_9, m_stcSplitScreen[1][3]);
	DDX_Control(pDX, IDC_BUTTON_10, m_stcSplitScreen[1][4]);
	DDX_Control(pDX, IDC_BUTTON_11, m_stcSplitScreen[2][0]);
	DDX_Control(pDX, IDC_BUTTON_12, m_stcSplitScreen[2][1]);
	DDX_Control(pDX, IDC_BUTTON_13, m_stcSplitScreen[2][2]);
	DDX_Control(pDX, IDC_BUTTON_14, m_stcSplitScreen[2][3]);
	DDX_Control(pDX, IDC_BUTTON_15, m_stcSplitScreen[2][4]);
	DDX_Control(pDX, IDC_BUTTON_16, m_stcSplitScreen[3][0]);
	DDX_Control(pDX, IDC_BUTTON_17, m_stcSplitScreen[3][1]);
	DDX_Control(pDX, IDC_BUTTON_18, m_stcSplitScreen[3][2]);
	DDX_Control(pDX, IDC_BUTTON_19, m_stcSplitScreen[3][3]);
	DDX_Control(pDX, IDC_BUTTON_20, m_stcSplitScreen[3][4]);
	DDX_Control(pDX, IDC_BUTTON_21, m_stcSplitScreen[4][0]);
	DDX_Control(pDX, IDC_BUTTON_22, m_stcSplitScreen[4][1]);
	DDX_Control(pDX, IDC_BUTTON_23, m_stcSplitScreen[4][2]);
	DDX_Control(pDX, IDC_BUTTON_24, m_stcSplitScreen[4][3]);
	DDX_Control(pDX, IDC_BUTTON_25, m_stcSplitScreen[4][4]);
	DDX_Control(pDX, IDC_EDT_ROW, m_edtRow);
	DDX_Control(pDX, IDC_EDT_COL, m_edtCol);
	DDX_Control(pDX, IDC_COMBO_SCREENTYPE, m_cboScreenType);
}


BEGIN_MESSAGE_MAP(CLS_PageSettingMutiSreen, CDialog)
	ON_BN_CLICKED(IDC_BTN_SET, &CLS_PageSettingMutiSreen::OnBnClickedBtnSet)
	ON_CBN_SELCHANGE(IDC_COMBO_NO, &CLS_PageSettingMutiSreen::OnCbnSelchangeComboNo)
	ON_CBN_SELCHANGE(IDC_COMBO_MODE, &CLS_PageSettingMutiSreen::OnCbnSelchangeComboMode)
	ON_CONTROL_RANGE(CBN_SELCHANGE, IDC_COMBO_CHN1, IDC_COMBO_CHN25, OnSelChannelChangeCombo)
	ON_BN_CLICKED(IDC_BTN_SET48, &CLS_PageSettingMutiSreen::OnBnClickedBtnSet48)
	ON_BN_CLICKED(IDC_BTN_SET96, &CLS_PageSettingMutiSreen::OnBnClickedBtnSet96)
	ON_BN_CLICKED(IDC_BTN_SET_SPECIAL, &CLS_PageSettingMutiSreen::OnBnClickedBtnSetSpecial)
	ON_BN_CLICKED(IDC_BUTTON_1, &CLS_PageSettingMutiSreen::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON_2, &CLS_PageSettingMutiSreen::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON_3, &CLS_PageSettingMutiSreen::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON_4, &CLS_PageSettingMutiSreen::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON_5, &CLS_PageSettingMutiSreen::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON_6, &CLS_PageSettingMutiSreen::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON_7, &CLS_PageSettingMutiSreen::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON_8, &CLS_PageSettingMutiSreen::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON_9, &CLS_PageSettingMutiSreen::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON_10, &CLS_PageSettingMutiSreen::OnBnClickedButton10)
	ON_BN_CLICKED(IDC_BUTTON_11, &CLS_PageSettingMutiSreen::OnBnClickedButton11)
	ON_BN_CLICKED(IDC_BUTTON_12, &CLS_PageSettingMutiSreen::OnBnClickedButton12)
	ON_BN_CLICKED(IDC_BUTTON_13, &CLS_PageSettingMutiSreen::OnBnClickedButton13)
	ON_BN_CLICKED(IDC_BUTTON_14, &CLS_PageSettingMutiSreen::OnBnClickedButton14)
	ON_BN_CLICKED(IDC_BUTTON_15, &CLS_PageSettingMutiSreen::OnBnClickedButton15)
	ON_BN_CLICKED(IDC_BUTTON_16, &CLS_PageSettingMutiSreen::OnBnClickedButton16)
	ON_BN_CLICKED(IDC_BUTTON_17, &CLS_PageSettingMutiSreen::OnBnClickedButton17)
	ON_BN_CLICKED(IDC_BUTTON_18, &CLS_PageSettingMutiSreen::OnBnClickedButton18)
	ON_BN_CLICKED(IDC_BUTTON_19, &CLS_PageSettingMutiSreen::OnBnClickedButton19)
	ON_BN_CLICKED(IDC_BUTTON_20, &CLS_PageSettingMutiSreen::OnBnClickedButton20)
	ON_BN_CLICKED(IDC_BUTTON_21, &CLS_PageSettingMutiSreen::OnBnClickedButton21)
	ON_BN_CLICKED(IDC_BUTTON_22, &CLS_PageSettingMutiSreen::OnBnClickedButton22)
	ON_BN_CLICKED(IDC_BUTTON_23, &CLS_PageSettingMutiSreen::OnBnClickedButton23)
	ON_BN_CLICKED(IDC_BUTTON_24, &CLS_PageSettingMutiSreen::OnBnClickedButton24)
	ON_BN_CLICKED(IDC_BUTTON_25, &CLS_PageSettingMutiSreen::OnBnClickedButton25)
END_MESSAGE_MAP()

// CLS_PageSettingMutiSreen message handlers
void CLS_PageSettingMutiSreen::OnSelChannelChangeCombo(UINT _iID)//ȡCombox
{
	EnableWindow(FALSE);

	//ȡĿǰѡеͨ
	int iRowSel = (_iID - IDC_COMBO_CHN1)/MAX_SPLIT_SCREEN_COL;
	int iColSel = (_iID - IDC_COMBO_CHN1)%MAX_SPLIT_SCREEN_COL;
	int iSel = m_cboSplitScreen[iRowSel][iColSel].GetCurSel();
	m_iSelChanSplitScreen[iRowSel][iColSel] = m_cboSplitScreen[iRowSel][iColSel].GetItemData(iSel);

	int iScreenNo = m_cmbScreenNo.GetCurSel();
	InitScreenInfo(iScreenNo);

	int iConnectMode = m_cmbConMode.GetCurSel();
	int iRow = 0;
	int iCol = 0;
	sscanf_s(CONST_cstrArrayConnectMode[iConnectMode], CONST_cstrConnectFormat, &iRow, &iCol);

	//з
	CString cstrChannel = GetText(IDS_MAIN_CHANNEL);
	for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
	{
		for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
		{
			//ɾѡеͨ
			for (int m=0; m<MAX_SPLIT_SCREEN_ROW; m++)
			{
				for(int n=0; n<MAX_SPLIT_SCREEN_COL; n++)
				{
					if (i == m && j== n)
					{
						continue;
					}

					if (m_iSelChanSplitScreen[m][n] != FILL_CHANNEL_INVALIDATE_DATA)
					{
						for (int k=0; k<m_cboSplitScreen[i][j].GetCount(); k++)
						{
							if (m_iSelChanSplitScreen[m][n] == m_cboSplitScreen[i][j].GetItemData(k))
							{
								m_cboSplitScreen[i][j].DeleteString(k);
								break;
							}
						}
					}
				}
			}

			//ѡеǰѡеͨ
			CString cstrTmp;
			cstrTmp.Format("%d", m_iSelChanSplitScreen[i][j] + 1);
			int iChannelIndex = m_cboSplitScreen[i][j].SelectString(-1,cstrChannel + cstrTmp);
			if (iChannelIndex == CB_ERR)
			{
				m_cboSplitScreen[i][j].SetCurSel(0);
			}
		}
	}

	EnableWindow(TRUE);
}

void CLS_PageSettingMutiSreen::OnBnClickedBtnSet()
{
	CreateVVOInfo strctCreateVVOInfo = {0};
	if(FillSplitScreenCreateVVOInfo(strctCreateVVOInfo))
	{
		int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &strctCreateVVOInfo, sizeof(CreateVVOInfo));
		if(0 != iRet)
		{
			AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingMutiSreen::OnBnClickedBtnSet] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
				,iRet,GetLastError(),m_lLogonID, 0, 0);
			
		}
		else //ɹ󽫴ֵ
		{
			int iChoose = m_cmbScreenNo.GetCurSel();
			if(iChoose < 0 || iChoose >= DEC_MAX_SPLIT_CHANNEL_NUM)
				return ;
			m_strctCreateVVOInfo[iChoose] = strctCreateVVOInfo;
			m_iConMode = m_cmbScreenNo.GetCurSel();
		}
	}
}

BOOL CLS_PageSettingMutiSreen::OnInitDialog()
{
	CDialog::OnInitDialog();

	InitCtrl();
	InitSplitScreenArray();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CLS_PageSettingMutiSreen::OnCbnSelchangeComboNo()
{
	int iItemIndex = m_cmbScreenNo.GetCurSel();
	UpdateMultiScreenInfo(iItemIndex);
	//ϢģʽϢ.
}

void CLS_PageSettingMutiSreen::OnCbnSelchangeComboMode()
{
	int iScreenNo = m_cmbScreenNo.GetCurSel();
	InitScreenInfo(iScreenNo);

	int iItemIndex = m_cmbConMode.GetCurSel();
	UpdateChannelMatix(iItemIndex);
}

void CLS_PageSettingMutiSreen::InitSplitScreenArray()
{
	for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
	{
		for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
		{
			m_iSelChanSplitScreen[i][j] = FILL_CHANNEL_INVALIDATE_DATA;
		}
	}
}

void CLS_PageSettingMutiSreen::UpdateChannelMatix( int _iConnectMode /*= 0*/ )
{
	for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
	{
		for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
		{
			m_cboSplitScreen[i][j].EnableWindow(FALSE);
			m_cboSplitScreen[i][j].SetCurSel(0);
			m_stcSplitScreen[i][j].ShowWindow(SW_HIDE);
			m_iSelChanSplitScreen[i][j] = FILL_CHANNEL_INVALIDATE_DATA;
		}
	}

	switch(_iConnectMode)
	{
	case 0://ûЧģʽ("--")
		break;
	default:
		{
			int iRow = 0;
			int iCol = 0;
			sscanf_s(CONST_cstrArrayConnectMode[_iConnectMode], CONST_cstrConnectFormat, &iRow, &iCol);

			int iScreenIndex = m_cmbScreenNo.GetCurSel();

			m_tInfo.iCols = iCol;
			m_tInfo.iRows = iRow;

			CString cstrTmp = "";
			CString cstrChannel = GetText(IDS_MAIN_CHANNEL);
			int iChannelIndex = 0;
			int iStcIndex = 0;
			if (m_iConMode == _iConnectMode)
			{
				for (int i=0; i<iRow; i++)
				{
					//ѡǾģʽʾ豸ͨϢ
					for(int j=0; j<iCol; j++)
					{
						iChannelIndex = m_strctCreateVVOInfo[iScreenIndex].iInputChannel[iStcIndex++];
						cstrTmp.Format("%d",iStcIndex);

						m_stcSplitScreen[i][j].ShowWindow(SW_SHOW);
						m_stcSplitScreen[i][j].SetWindowText(cstrTmp);

						m_cboSplitScreen[i][j].EnableWindow(TRUE);
						if (iChannelIndex < m_iChannelNum && iChannelIndex >=0)
						{
							cstrTmp.Format("%d", iChannelIndex + 1);
							iChannelIndex = m_cboSplitScreen[i][j].SelectString(-1,cstrChannel + cstrTmp);
							if (iChannelIndex == CB_ERR)
							{
								m_iSelChanSplitScreen[i][j] = FILL_CHANNEL_INVALIDATE_DATA;
								m_cboSplitScreen[i][j].SetCurSel(0);
							}
							else
							{
								m_iSelChanSplitScreen[i][j] = m_cboSplitScreen[i][j].GetItemData(iChannelIndex);
							}
						}
						else
						{
							m_iSelChanSplitScreen[i][j] = FILL_CHANNEL_INVALIDATE_DATA;
							m_cboSplitScreen[i][j].SetCurSel(0);
						}
					}
				}
			} 
			else
			{
				//ѡģʽС
				for (int i=0; i<iRow; i++)
				{
					for(int j=0; j<iCol; j++)
					{
						iStcIndex++;
						cstrTmp.Format("%d",iStcIndex);

						m_stcSplitScreen[i][j].ShowWindow(SW_SHOW);
						m_stcSplitScreen[i][j].SetWindowText(cstrTmp);

						m_cboSplitScreen[i][j].EnableWindow(TRUE);
						m_iSelChanSplitScreen[i][j] = m_cboSplitScreen[i][j].GetItemData(iCol*i + j + 1);
						m_cboSplitScreen[i][j].SetCurSel(iCol*i + j + 1);
					}
				}
			}
		}
		break;
	}

	OnSelChannelChangeCombo(IDC_COMBO_CHN1);
}

int CLS_PageSettingMutiSreen::Initialize(TDECPARAM* _pdecParam)
{
	if (_pdecParam)
	{
		m_iChannelNum = _pdecParam->m_iChannel;//ֻȡͨĿ
	}

	if (m_iChannelNum < 0 || m_iChannelNum > DEC_MAX_PHYSICAL_CHANNEL_NUM)
	{
		m_iChannelNum = 0;
	}

	UpdateMultiScreenInfo(0);
	return 0;
}

void CLS_PageSettingMutiSreen::SetLogonID( LONG _lLogonID )
{
	m_lLogonID = _lLogonID;
}

void CLS_PageSettingMutiSreen::InitCtrl()
{
	SetDlgItemText(IDC_STATIC_MUTI_SCREEN, GetText(IDS_SETTING_MULI_SCREEN));
	SetDlgItemText(IDC_STATIC_NO, GetText(IDS_STRING_SCREEN_NO));
	SetDlgItemText(IDC_STATIC_MODE, GetText(IDS_STRING_CONNECT_MODE));
	SetDlgItemText(IDC_BTN_SET, GetText(IDS_STRING_SET));
	CString cstrTmp ;
	CString cstrScreenTitle= GetText(IDS_SETTING_MULI_SCREEN_TITLE);
	tDevInfo tDevInformation = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInformation, sizeof(tDevInfo));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	for (int i=0; i<tDevInformation.iSplitChanNum; i++)
	{
		cstrTmp.Format("%d",i + 1);
		m_cmbScreenNo.AddString(cstrScreenTitle + cstrTmp);
	}
	m_cmbScreenNo.SetCurSel(0);
	m_cboScreenType.SetCurSel(0);
}

void CLS_PageSettingMutiSreen::InitConnectMode(int _iChannelCanUse)
{
	if (_iChannelCanUse < 0 || _iChannelCanUse > DEC_MAX_PHYSICAL_CHANNEL_NUM)
	{
		_iChannelCanUse = 0;
	}

	int iModeIndex = 0;
	switch(_iChannelCanUse)
	{
	case 1:
		iModeIndex = 2;
		break;
	case 2:
	case 3:
		iModeIndex = 4;//3;
		break;
	case 4:
	case 5:
		iModeIndex = 5;//4;
		break;
	case 6:
	case 7:
		iModeIndex = 7;//6;
		break;
	case 8:
		iModeIndex = 9;//8;
		break;
	case 9:
	case 10:
	case 11:
		iModeIndex = 10;//9;
		break;
	case 12:
	case 13:
	case 14:
		iModeIndex = 12;//11;
		break;
	case 15:
		iModeIndex = 14;//13;
		break;
	case 16:
		iModeIndex = 15;
		break;
	case 0:
	default:
		iModeIndex = 1;
		break;
	}


	if (_iChannelCanUse > 16){
		iModeIndex = 15;
	}
	m_cmbConMode.ResetContent();
	for (int i=0; i< iModeIndex; i++)
	{
		m_cmbConMode.AddString(CONST_cstrArrayConnectMode[i]);
	}

	CString cstrTmp = CONST_cstrInvaldateSelect;
	int iScreenIndex = m_cmbScreenNo.GetCurSel();
	if (m_strctCreateVVOInfo[iScreenIndex].iCols > 0 && m_strctCreateVVOInfo[iScreenIndex].iRows > 0)
	{
		cstrTmp.Format(CONST_cstrConnectFormat,m_strctCreateVVOInfo[iScreenIndex].iRows, m_strctCreateVVOInfo[iScreenIndex].iCols);
	}

	int iIndex = m_cmbConMode.SelectString(0,cstrTmp);
	if (iIndex < 0)
	{
		m_cmbConMode.SetCurSel(0);
		iIndex = 0;
	}

	m_iConMode = iIndex;
	UpdateChannelMatix(iIndex);
}

int CLS_PageSettingMutiSreen::UpdateMultiScreenInfo( int _iScreenNo )
{
	int iChannelUsed = InitScreenInfo(_iScreenNo);

	int iRow = m_strctCreateVVOInfo[_iScreenNo].iRows;
	int iCol = m_strctCreateVVOInfo[_iScreenNo].iCols;
	SetDlgItemInt(IDC_EDT_ROW,iRow);
	SetDlgItemInt(IDC_EDT_COL,iCol);
	int iSplitScreenNum = m_strctCreateVVOInfo[_iScreenNo].iRows * m_strctCreateVVOInfo[_iScreenNo].iCols;
	if(iRow >= 5 || iCol >= 5){
		goto LCountChannel;
	}
	bool blSelected = false;
	int iCurChannel = -1;
	int iChannelIndex = -1;

	for (int i=0; i<iSplitScreenNum; i++)//ǰʹõͨѡ
	{
		iChannelIndex = m_strctCreateVVOInfo[_iScreenNo].iInputChannel[i];
		if (iChannelIndex>=0 && iChannelIndex<m_iChannelNum)		
		{
			blSelected = false;
			for (int j=0; j<m_cboSplitScreen[i/iRow][i%iCol].GetCount(); j++)
			{
				iCurChannel = m_cboSplitScreen[i/iRow][i%iCol].GetItemData(j);
				if (iCurChannel == iChannelIndex)
				{
					 m_cboSplitScreen[i/iCol][i%iCol].SetCurSel(j);
					 m_iSelChanSplitScreen[i/iCol][i%iCol] = iCurChannel;
					 
					 blSelected = true;
					 break;
				}
			}
			if (!blSelected)
			{
				m_cboSplitScreen[i/iRow][i%iCol].SetCurSel(0);
				m_iSelChanSplitScreen[i/iRow][i%iCol] = FILL_CHANNEL_INVALIDATE_DATA;
			}
		}
		else
		{
			m_cboSplitScreen[i/iRow][i%iCol].SetCurSel(0);
			m_iSelChanSplitScreen[i/iRow][i%iCol] = FILL_CHANNEL_INVALIDATE_DATA;
		}
	}
LCountChannel:
	int iChannelCanUse = m_iChannelNum - iChannelUsed;

	InitConnectMode(iChannelCanUse);

	memcpy(&m_tInfo,&m_strctCreateVVOInfo[_iScreenNo],sizeof(CreateVVOInfo));

	return 0;
}

bool CLS_PageSettingMutiSreen::FillSplitScreenCreateVVOInfo(CreateVVOInfo& _strctCreateVVOInfo)
{
	memset(&_strctCreateVVOInfo,0,sizeof(CreateVVOInfo));
	_strctCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);

	BaseOffset tGetStartAddress = {0};
	tGetStartAddress.iSize = sizeof(BaseOffset);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
		return 0;
	}
	_strctCreateVVOInfo.iVVOChannelNo = m_cmbScreenNo.GetCurSel() + tGetStartAddress.iSplitScreen;
	//ȫʼΪδѡ
	memset(&_strctCreateVVOInfo.iInputChannel,FILL_CHANNEL_INVALIDATE_DATA,sizeof(_strctCreateVVOInfo.iInputChannel));

	int iConMode = m_cmbConMode.GetCurSel();
	if (iConMode == 0)//ûѡģʽ
	{
		_strctCreateVVOInfo.iRows = 0;
		_strctCreateVVOInfo.iCols = 0;
	}
	else
	{
		CString cstrTmp = "";
		m_cmbConMode.GetWindowText(cstrTmp);
		_strctCreateVVOInfo.iRows = StrToInt(cstrTmp.Left(1));
		_strctCreateVVOInfo.iCols = StrToInt(cstrTmp.Right(1));
	}

	int iIndexChannel = -1;
	bool blNoSel = false;//ûѡͨ

	_strctCreateVVOInfo.iScreenType = m_cboScreenType.GetCurSel();

	int iIndex = 0;

	for (int i=0; i<_strctCreateVVOInfo.iRows; i++)
	{
		for (int j=0; j< _strctCreateVVOInfo.iCols; j++)
		{
			iIndexChannel = m_cboSplitScreen[i][j].GetCurSel();
			if (iIndexChannel > 0)
			{
				_strctCreateVVOInfo.iInputChannel[iIndex] = m_cboSplitScreen[i][j].GetItemData(iIndexChannel);
				_strctCreateVVOInfo.tInputChannelParam[iIndex].iMode = m_tInfo.tInputChannelParam[iIndex].iMode;
				_strctCreateVVOInfo.tInputChannelParam[iIndex].tSplitScreenPara.iX = m_tInfo.tInputChannelParam[iIndex].tSplitScreenPara.iX;
				_strctCreateVVOInfo.tInputChannelParam[iIndex].tSplitScreenPara.iY = m_tInfo.tInputChannelParam[iIndex].tSplitScreenPara.iY;
				_strctCreateVVOInfo.tInputChannelParam[iIndex].tSplitScreenPara.iWidth = m_tInfo.tInputChannelParam[iIndex].tSplitScreenPara.iWidth;
				_strctCreateVVOInfo.tInputChannelParam[iIndex].tSplitScreenPara.iHeight = m_tInfo.tInputChannelParam[iIndex].tSplitScreenPara.iHeight;

				iIndex++;
			}
			else
			{
				blNoSel = true;
				iIndex++;//ʹõĲ
				//_strctCreateVVOInfo.iInputChannel[iIndex++] = FILL_CHANNEL_INVALIDATE_DATA;
			}
		}
	}

	if (iConMode != 0 && blNoSel)
	{
		MessageBox(GetText(IDS_MUTISCREEN_NO_CHANNEL_SELECTED), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
		return false;
	}

	//жͨǷѡظ
	int iSum = DEC_MAX_SPLIT_SCREEN_NUM;//iRow*iCol;
	int iChannel = -1;
	bool blReused = false;
	while(iSum > 0)
	{
		iChannel = _strctCreateVVOInfo.iInputChannel[iSum - 1];
		if (iChannel>m_iChannelNum || iChannel<0)
		{
			iSum--;
			continue;
		}
		for (int i=0; i<iSum - 1; i++)
		{
			if (_strctCreateVVOInfo.iInputChannel[i] == iChannel)
			{
				blReused = true;
				break;
			}
		}
		if (!blReused)
		{
			iSum--;
		}
		else
		{
			break;
		}
	}

	if (blReused)
	{
		MessageBox(GetText(IDS_MUTISCREEN_CHANNEL_SEL_REPEAT), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
		return false;
	}
	return true;
}

BOOL CLS_PageSettingMutiSreen::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

int CLS_PageSettingMutiSreen::InitScreenInfo( int _iScreenNo )
{
	bool blUsedChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM] = {false};//ʹõͨΪ棬Ϊ١
	for(int i=0; i<DEC_MAX_PHYSICAL_CHANNEL_NUM; i++)
	{
		blUsedChannel[i] = false;
	}

	int iItemIndex = 0;
	int iChannelIndex = -1;
	int iChannelUsed = 0;

	int iSplitScreenNum = -1;

	for (int i=0; i<DEC_MAX_SPLIT_CHANNEL_NUM; i++)//õƴѾʹõͨ.
	{
		BaseOffset tGetStartAddress = {0};
		tGetStartAddress.iSize = sizeof(BaseOffset);
		int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
			&tGetStartAddress, sizeof(BaseOffset));
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
			return 0;
		}

		memset(&m_strctCreateVVOInfo[i], 0, sizeof(CreateVVOInfo));
		m_strctCreateVVOInfo[i].iBufSize = sizeof(CreateVVOInfo);
		m_strctCreateVVOInfo[i].iVVOChannelNo = i + tGetStartAddress.iSplitScreen;
		memset(&m_strctCreateVVOInfo[i].iInputChannel,FILL_CHANNEL_INVALIDATE_DATA,sizeof(m_strctCreateVVOInfo[i].iInputChannel));

		iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &m_strctCreateVVOInfo[i], sizeof(CreateVVOInfo));
		if(0 != iRet)
		{
			AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingMutiSreen::OnBnClickedBtnSet] DEC_ClientGetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
				,iRet,GetLastError(),m_lLogonID, 0, 0);
			continue;
		}

		if (m_strctCreateVVOInfo[i].iCols == 0 || m_strctCreateVVOInfo[i].iRows == 0)
		{
			memset(&m_strctCreateVVOInfo[i].iInputChannel,FILL_CHANNEL_INVALIDATE_DATA,sizeof(m_strctCreateVVOInfo[i].iInputChannel));
		}

		if (i != _iScreenNo)//ǵǰͨͨ.
		{
			iSplitScreenNum = m_strctCreateVVOInfo[i].iRows * m_strctCreateVVOInfo[i].iCols;

			for (int j=0; j<iSplitScreenNum; j++)
			{
				iChannelIndex = m_strctCreateVVOInfo[i].iInputChannel[j];
				if (iChannelIndex < DEC_MAX_PHYSICAL_CHANNEL_NUM && iChannelIndex >= 0)
				{
					blUsedChannel[iChannelIndex] = true;
					iChannelUsed++;
				}
			}
		}
	}

	for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
	{
		for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
		{
			m_cboSplitScreen[i][j].ResetContent();
		}
	}

	iSplitScreenNum = m_strctCreateVVOInfo[_iScreenNo].iRows * m_strctCreateVVOInfo[_iScreenNo].iCols;
	int iRow = m_strctCreateVVOInfo[_iScreenNo].iRows;
	int iCol = m_strctCreateVVOInfo[_iScreenNo].iCols;

	CString cstrChannelName = GetText(IDS_MAIN_CHANNEL);
	CString cstrTmp = "";

	int iNuSelIndex = -1;
	cstrTmp = CONST_cstrInvaldateSelect;//δѡ,
	for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
	{
		for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
		{
			iNuSelIndex = m_cboSplitScreen[i][j].AddString(cstrTmp);
			m_cboSplitScreen[i][j].SetItemData(iNuSelIndex,FILL_CHANNEL_INVALIDATE_DATA);
		}
	}

	for (int k=0; k<m_iChannelNum; k++)//õͨ
	{
		if (!blUsedChannel[k])
		{
			cstrTmp.Format("%d", k + 1);
			for (int i=0; i<MAX_SPLIT_SCREEN_ROW; i++)
			{
				for(int j=0; j<MAX_SPLIT_SCREEN_COL; j++)
				{
					iItemIndex = m_cboSplitScreen[i][j].AddString(cstrChannelName + cstrTmp);
					m_cboSplitScreen[i][j].SetItemData(iItemIndex,k);//ͨ
				}
			}
		}
	}

	return iChannelUsed;
}

void CLS_PageSettingMutiSreen::Fill96SplitScreenCreateVVOInfo(CreateVVOInfo& _strctCreateVVOInfo,int x, int y)
{
	_strctCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	_strctCreateVVOInfo.iVVOChannelNo = 96;
	_strctCreateVVOInfo.iRows = x;
	_strctCreateVVOInfo.iCols = y;
	for(int i = 0; i < 96; i++)
	{
		_strctCreateVVOInfo.iInputChannel[i] = i;
	}
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &_strctCreateVVOInfo, sizeof(CreateVVOInfo));
	if(0 != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingMutiSreen::Fill96SplitScreenCreateVVOInfo] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)",iRet,GetLastError(),m_lLogonID, 0, 0);

	}
}


void CLS_PageSettingMutiSreen::FillAnySplitScreenCreateVVOInfo(CreateVVOInfo& _strctCreateVVOInfo,int x, int y,bool* bChannelChack)
{
	_strctCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	BaseOffset tGetStartAddress = {0};
	tGetStartAddress.iSize = sizeof(BaseOffset);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_lLogonID);
		return;
	}
	_strctCreateVVOInfo.iVVOChannelNo = m_cmbScreenNo.GetCurSel() + tGetStartAddress.iSplitScreen;
	_strctCreateVVOInfo.iRows = x;
	_strctCreateVVOInfo.iCols = y;
	for(int i = 0,j = 0; (i < m_iChannelNum) && (j < x * y); i++)
	{
		if(bChannelChack[i] == false){
			_strctCreateVVOInfo.iInputChannel[j] = i;
			j++;
		}
	}
	iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &_strctCreateVVOInfo, sizeof(CreateVVOInfo));
	if(0 != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingMutiSreen::Fill96SplitScreenCreateVVOInfo] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)",iRet,GetLastError(),m_lLogonID, 0, 0);

	}
}


void CLS_PageSettingMutiSreen::Fill48SplitScreenCreateVVOInfo(CreateVVOInfo& _strctCreateVVOInfo,int x, int y)
{
	_strctCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	_strctCreateVVOInfo.iVVOChannelNo = 48;
	_strctCreateVVOInfo.iRows = x;
	_strctCreateVVOInfo.iCols = y;
	for(int i = 0; i < 48; i++)
	{
		_strctCreateVVOInfo.iInputChannel[i] = i;
	}
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &_strctCreateVVOInfo, sizeof(CreateVVOInfo));
	if(0 != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingMutiSreen::Fill96SplitScreenCreateVVOInfo] DEC_ClientSetDevConfig Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)",iRet,GetLastError(),m_lLogonID, 0, 0);

	}
}
void CLS_PageSettingMutiSreen::OnBnClickedBtnSet48()
{
	
	int x = GetDlgItemInt(IDC_EDT_ROW);
	int y = GetDlgItemInt(IDC_EDT_COL);
	CreateVVOInfo tInfo = {0};
	if(x * y != 48)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PARAM), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
		return;
	}
	Fill48SplitScreenCreateVVOInfo(tInfo, x, y);
}

void CLS_PageSettingMutiSreen::OnBnClickedBtnSet96()
{
	int x = GetDlgItemInt(IDC_EDT_ROW);
	int y = GetDlgItemInt(IDC_EDT_COL);
	CreateVVOInfo tInfo = {0};
	if(x * y != 96)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PARAM), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
		return;
	}
	Fill96SplitScreenCreateVVOInfo(tInfo, x, y);
}

void CLS_PageSettingMutiSreen::OnBnClickedBtnSetSpecial()
{
	// TODO: ڴӿؼ֪ͨ
	int iUsedChannel = 0;
	int iUsedScreen = 0;
	int iCurrentChannel = m_cmbScreenNo.GetCurSel();
	bool bUsedChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM] = {false};
	bool bUsedScreen[DEC_MAX_SPLIT_CHANNEL_NUM] = {false};
	CheckChannel(m_lLogonID, bUsedChannel, &iUsedChannel, bUsedScreen, &iUsedScreen, iCurrentChannel);
	int iChannelCanUse = m_iChannelNum - iUsedChannel;
	int x = GetDlgItemInt(IDC_EDT_ROW);
	int y = GetDlgItemInt(IDC_EDT_COL);
	if(x * y > iChannelCanUse){
		MessageBox("param error!", _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
		return;
	}
	CreateVVOInfo tInfo = {0};
	FillAnySplitScreenCreateVVOInfo(tInfo,x,y,bUsedChannel);
}

void CLS_PageSettingMutiSreen::SetScreenParam(int _iIndex)
{
	CLS_DlgScreenParam dlgScreenParam(&m_tInfo.tInputChannelParam[_iIndex]);
	dlgScreenParam.DoModal();
}

void CLS_PageSettingMutiSreen::OnBnClickedButton1()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(0);
}


void CLS_PageSettingMutiSreen::OnBnClickedButton2()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(1);
}
void CLS_PageSettingMutiSreen::OnBnClickedButton3()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(2);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton4()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(3);
}


void CLS_PageSettingMutiSreen::OnBnClickedButton5()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(4);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton6()
{
	// TODO: Add your control notification handler code here

	SetScreenParam( m_tInfo.iCols + 0);

}

void CLS_PageSettingMutiSreen::OnBnClickedButton7()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols + 1);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton8()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols + 2);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton9()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols + 3);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton10()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols + 4);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton11()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*2 + 0);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton12()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*2 + 1);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton13()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*2 + 2);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton14()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*2 + 3);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton15()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*2 + 4);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton16()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*3 + 0);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton17()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*3 + 1);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton18()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*3 + 2);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton19()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*3 + 3);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton20()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*3 + 4);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton21()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*4 + 0);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton22()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*4 + 1);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton23()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*4 + 2);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton24()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*4 + 3);
}

void CLS_PageSettingMutiSreen::OnBnClickedButton25()
{
	// TODO: Add your control notification handler code here
	SetScreenParam(m_tInfo.iCols*4 + 4);
}

